function [FGLS,se] = xtreg(Y,X)
% Panel estimation.

    N = size(Y,1);                                                          % Number of states.
    T = size(Y,2);                                                          % Number of years.
    nobs = N*T;                                                             % Sample size.

    numx = size(X,2)/T;                                                     % Number of regressors.

    % OLS coefficients and residuals.

    yvec = reshape(Y,nobs,1) ;
    xvec = zeros(nobs,numx);

    for i = 1:numx
        xvec(:,i) = reshape(X(:,((i-1)*T+1):(i*T)),nobs,1);
    end

    ols = inv(xvec'*xvec)*xvec'*yvec  ;
    resid = yvec - xvec*ols ;
    residNT = reshape(resid,N,T) ;
    
    % Correct for heteroskedasticity across states.
    
    var_s = (1/T).*sum(residNT.^2,2);                                       % Squared residuals averaged over time for each state.
    var_mat = diag(var_s);
    omega = kron(eye(T),var_mat);                                           
    
    het = inv(sqrtm(omega));                                               
    
    yhet = het*yvec;
    xhet = het*xvec;
    
    % OLS on transformed regression.
    
    FGLS = inv(xhet'*xhet)*xhet'*yhet;
    
    resid_het = yhet - xhet*FGLS;
    s2 = (resid_het'*resid_het)/(nobs-numx);
    
    vcmat = s2*inv(xhet'*xhet);
    
    se = (diag(vcmat)).^(1/2);
    

end

