function[fe_Y,fe_X] = fe(Y,X,tfe,cfe)
% Fixed effects. 

N = size(Y,1);
T = size(Y,2);
W = ones(N,T);

if tfe == 1 && cfe == 0

    % Time fixed effects.
    
    fe_Y = (sum(Y.*W))./(sum(W.^2));
    fe_Y = Y - (W.*(ones(N,1)*fe_Y));
    
    fe_X = (sum(X.*W))./(sum(W.^2));
    fe_X = X - (W.*(ones(N,1)*fe_X));

elseif cfe == 1 && tfe == 0

    % Cross section fixed effects.
    
    fe_Y = (sum((Y.*W),2))./(sum((W).^2,2));
    fe_Y = Y - (W.*(fe_Y*ones(1,T)));   
   
    fe_X = (sum((X.*W),2))./(sum((W).^2,2));
    fe_X = X - (W.*(fe_X*ones(1,T)));

end

end

