%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Econometrics 2
% Homework 8
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This code and function files are based on the Gauss code of Prof. Bent 
% Sorensen. This estimates a panel regression with fixed effects via FGLS. 
% See Ostergaard, Sorensen and Yosha (JPE, 2002) for details.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear
clc

p = 1;                                                                      % pth difference.
k = 1;                                                                      % kth lag.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Data preparation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Load data.

load data                                                         

pops = [pops6396(1:8,:); pops6396(10:51,:)];                                % Population.  
pops = pops(:,1:33);   

cpi_vec = cpi6396(1:33);                                                    % CPI.
cpi     = kron(ones(size(pops,1),1),cpi_vec');

dpinc = [dpi6396(1:8,:); dpi6396(10:51,:)];                                 % Income.
dpinc = dpinc(:,1:33);

dpi_agg = sum(dpinc)';                                                      % Aggregate.
dpinc   = dpinc./cpi;                  
dpi_agg = dpi_agg./cpi_vec;

ndur6395 = ndur6095(:,4:36);                                                % Non-durables.
ndur     = [ndur6395(1:8,:); ndur6395(10:51,:)];

sale = ndur./cpi;                                                           
perc = sum(ndur)';                                                          
perc = perc./cpi_vec;                                                       % Non-durable consumption.

clear ndur cpi cpi_vec pops6396 cpi6396 dpi6396 ndur6095 ndur6395

% Make everything per capita.

dpi     = dpinc./pops;
sale    = sale./pops;
perc    = perc./sum(pops)';
dpi_agg = dpi_agg./sum(pops)';
dpi_agg = kron(ones(size(pops,1),1),dpi_agg');  
perc    = kron(ones(size(pops,1),1),perc');  

clear pops

% Take logs.

logdpi     = log(dpi);
logsale    = log(sale);
logperc    = log(perc);
logdpi_agg = log(dpi_agg);

clear dpi sale perc dpi_agg

% Take differences.

D = size(logdpi,2);

d_dpi     = idiff(logdpi,p,D);
d_sale    = idiff(logsale,p,D);
d_perc    = idiff(logperc,p,D);
d_dpi_agg  = idiff(logdpi_agg,p,D);

clear D p logdpi logsale logperc logdpi_agg

dpi_t = d_dpi';
dpi_1ag = lagmatrix(d_dpi',1);                                              % Lag matrix.

n1 = size(dpi_t,1);
n2 = size(dpi_1ag,1);

dpi_t = dpi_t(k+1:n1,:)';
dpi_1ag = dpi_1ag(k+1:n2,:)';

clear n1 n2 d_dpi

sale_t = d_sale' ;

n3 = size(sale_t,1);

sale_t = sale_t(k+1:n3,:)';

clear n3 d_sale

dpi_aggt = d_dpi_agg';
dpi_agg1ag = lagmatrix(d_dpi_agg',1);                                       % Lag matrix.

n4 = size(dpi_aggt,1);
n5 = size(dpi_agg1ag,1);

dpi_aggt = dpi_aggt(k+1:n4,:)';
dpi_agg1ag = dpi_agg1ag(k+1:n5,:)';

clear n4 n5 d_dpi_agg

perc_t = d_perc';

n6 = size(perc_t,1);

perc_t = perc_t(k+1:n6,:)';

clear n6 d_perc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Fixed effects.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Time fixed effects.

[dpi_t_ft,dpi_1_ft] = fe(dpi_t,dpi_1ag,1,0);
[dpi_atft,dpi_a1ft] = fe(dpi_t-dpi_aggt,dpi_1ag-dpi_agg1ag,1,0);
[saleatft,~]        = fe(sale_t-perc_t,perc_t,1,0);
[sale_tft,perc_tft] = fe(sale_t,perc_t,1,0);

% Cross section fixed effects.

[dpi_t_fx,dpi_1_fx] = fe(dpi_t,dpi_1ag,0,1);
[dpi_atfx,dpi_a1fx] = fe(dpi_t-dpi_aggt,dpi_1ag-dpi_agg1ag,0,1);
[sale_tfx,~]        = fe(sale_t,perc_t,0,1);
[saleatfx,perc_tfx] = fe(sale_t-perc_t,perc_t,0,1);

% Cross section and time fixed effects.

[dpi_t_fxt,dpi_1_fxt] = fe(dpi_t_fx,dpi_1_fx,1,0);                          % Cross fixed effects in place from above.
[sale_tfxt,~]         = fe(sale_tfx,perc_tfx,1,0);
[saleatfxt,perc_tfxt] = fe(saleatfx,perc_tfx,1,0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Estimation and Results.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

N = size(sale_t,1);
T = size(sale_t,2);
O = ones(N,T);

[gls1,glsstdev1] = xtreg(sale_t, [O dpi_t]);                                % Benchmark.

[gls2,glsstdev2] = xtreg(sale_tft,dpi_t_ft);                                % Risk Sharing.
[gls3,glsstdev3] = xtreg((sale_t-perc_t),[O dpi_t-dpi_aggt]);              
[gls4,glsstdev4] = xtreg(sale_tft, dpi_1_ft);                             
[gls5,glsstdev5] = xtreg((sale_t-perc_t), [O (dpi_1ag-dpi_agg1ag)]);

[gls6, glsstdev6] = xtreg(saleatfx,dpi_atfx);                               % Smoothness
[gls7, glsstdev7] = xtreg(sale_tfxt,dpi_t_fxt);

fprintf('--------------------------------------------------------------\n')
fprintf('BENCHMARK \n')
fprintf('--------------------------------------------------------------\n')

fprintf('Regression of C_it on constant and Y_it. No fixed effects. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls1(1,1), glsstdev1(1,1), gls1(1,1)/glsstdev1(1,1))
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls1(2,1), glsstdev1(2,1), gls1(2,1)/glsstdev1(2,1))
fprintf('\n')

fprintf('--------------------------------------------------------------\n')
fprintf('RISK SHARING \n')
fprintf('--------------------------------------------------------------\n')

fprintf('Regression of C_it on Y_it with time fixed effects only. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls2(1,1), glsstdev2(1,1), gls2(1,1)/glsstdev2(1,1))
fprintf('\n')

fprintf('Regression of (C_it-agg C_t) on constant and (Y_it-agg Y_t). \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls3(1,1), glsstdev3(1,1), gls3(1,1)/glsstdev3(1,1))
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls3(2,1), glsstdev3(2,1), gls3(2,1)/glsstdev3(2,1))
fprintf('\n')

fprintf('Regression on lagged income with time fixed effects. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls4(1,1), glsstdev4(1,1), gls4(1,1)/glsstdev4(1,1))
fprintf('\n')

fprintf('With aggregate income and aggregate consumption subtracted. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls5(1,1), glsstdev5(1,1), gls5(1,1)/glsstdev5(1,1))
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls5(2,1), glsstdev5(2,1), gls5(2,1)/glsstdev5(2,1))
fprintf('\n')

fprintf('--------------------------------------------------------------\n')
fprintf('SMOOTHNESS REGRESSIONS \n')
fprintf('--------------------------------------------------------------\n')

fprintf('Regression of (C_it-agg C_t) on (Y_it-agg Y_t) with cross section fixed effects. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls6(1,1), glsstdev6(1,1), gls6(1,1)/glsstdev6(1,1))
fprintf('\n')

fprintf('Regression of C_it on Y_it with both cross and time fixed effects. \n')
fprintf('\n')

fprintf('        b            SE             t \n')
fprintf('      %0.4f       %0.4f         %0.4f    \n', gls7(1,1), glsstdev7(1,1), gls7(1,1)/glsstdev7(1,1))
fprintf('\n')
