%{
    Xavier Martin G. Bautista
    Fall 2018
    Macro 3
    HW 2

    GMM_Main.m

    This replicates Hansen and Singleton (1982). Estimation is done using
    GMM. The variance matrix can be estimated using either Newey-West or
    Quadratic Spectral kernels.

    Note: Convention used is U(C) = (C^(1-gamma))/(1-gamma).
%}

%% 1. Change working directory and load data.

    close all
    clear 
    clc

    addpath('D:/Xavier_Laptops/Xavier_Asus/Xavier_Classes/Fall_2018/Macro3/HW2')
    
    global c lag re rf n T Z
    
    load data
    
    lag = 3;                                                                % Number of lags used as instruments. Make sure to change this with Z.
        
    c  = data(:,1);                                                         % c(t)/c(t-1).
    re = data(:,2);                                                         % Value-weighted average of stock returns.
    rf = data(:,3);                                                         % T-bill rate.
    
    T = size(data,1);
    Z = [ones(T-lag,1) c(1:T-3)  c(2:T-2) c(3:T-1)...                       % Instruments: 3 lags of consumption, T-bill rate
                      re(1:T-3) re(2:T-2) re(3:T-1)...                      % value-weighted average of stock returns.
                      rf(1:T-3) rf(2:T-2) rf(3:T-1)]; 
    n = size(Z,2);                                                          % Number of instruments including constant.
    
    clear data
        
%% 2. GMM Stage 1: Identity Weighting Matrix.
 
    b0 = [0.5 0.5];                                                         % Initial guess of beta and gamma, respectively.
    W  = weight(b0,0);                                                      % 0 = Identity matrix, 1 = Newey-West, 2 = Quadratic Spectral.

    opt = optimset('FinDiffType','central','HessUpdate','BFGS');            % Use central difference for derivative and BFGS algorithm.
    b1  = fminunc('gmm_obj',b0,opt,W);                                      % Weighting matrix is fixed (so fminunc doesn't optimize over it).
    
    clear W
    
%% 3. GMM Stage 2: Optimal Weighting Matrix.

    % Newey-West.

    W   = weight(b1,1);                                                        
    bNW = fminunc('gmm_obj',b1,opt,W);                                      % GMM Estimation.
        
    gradNW = Df(bNW);                                                       % Gradient.
    vmatNW = inv(gradNW'*W*gradNW);                                         % Variance matrix. Note: W = inv(omega).
    
    clear gradNW W Dgp1 Dgp2 Dgm1 Dgm2
    
    % Quadratic Spectral.
    
    W   = weight(b1,2);    
    bQS = fminunc('gmm_obj',b1,opt,W);                                      % GMM Estimation.
       
    gradQS = Df(bQS);                                                       % Gradient.    
    vmatQS = inv(gradQS'*W*gradQS);                                         % Variance matrix. Note: W = inv(omega).
    
    clear gradQS W Dgp1 Dgp2 Dgm1 Dgm2

%% 4. Print results.

    diary(['HansenSingleton_Output_',datestr(now,'dd-mm-yy','local'),'_',datestr(now,'hh-MM-ss','local'),'.txt'])   
    
    fprintf('Estimation Results (Newey-West Variance Estimator):\n\n')
    
        fprintf(' \t Coeff. \t SE (NW) \n\n')
        fprintf('beta \t %1.4f \t %1.4f  \n',bNW(1), sqrt(vmatNW(1,1)))
        fprintf('gamma \t %1.4f \t %1.4f \n\n',bNW(2), sqrt(vmatNW(2,2)))

    fprintf('Estimation Results (Quadratic Spectral Variance Estimator):\n\n')
    
        fprintf(' \t Coeff. \t SE (QS) \n\n')
        fprintf('beta \t %1.4f \t %1.4f  \n',bQS(1), sqrt(vmatQS(1,1)))
        fprintf('gamma \t %1.4f \t %1.4f \n\n',bQS(2), sqrt(vmatQS(2,2)))

    diary off